# -*- coding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2010 Tiny SPRL (<http://tiny.be>).
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import osv

class hrself_holidays_request_leave(osv.osv):

    _inherit = "hrself.holidays.request.leave"
    
    def _notify(self, cr, uid, email_template_name, ids):
        hrself_mail = self.pool.get('hrself.mail')
        hrself_mail.notify(cr, uid, email_template_name, ids)

    def _notify_approver_of_transfered_request(self, cr, uid, ids):
        """Sends an email to the approver the request has been transfered to."""
        send_ids = [leave_request.id for leave_request in self.browse(cr, uid, ids) if leave_request.leave_approver_id.hrself_email]
        if send_ids:
            email_template_name = '_notify_approver_of_transfered_request'
            self._notify(cr, uid, email_template_name, send_ids)

    def _notify_employee_of_approved_request(self, cr, uid, ids):
        """Sends an email to the employee to notify him of the approval of his/her leave request."""
        send_ids = [leave_request.id for leave_request in self.browse(cr, uid, ids) if leave_request.employee_id.hrself_email]
        if send_ids:
            email_template_name = '_notify_employee_of_approved_request'
            self._notify(cr, uid, email_template_name, send_ids)

    def _notify_employee_of_refused_request(self, cr, uid, ids):
        """Sends an email to the employee to notify him of the refusal of his/her leave request."""
        send_ids = [leave_request.id for leave_request in self.browse(cr, uid, ids) if leave_request.employee_id.hrself_email]
        if send_ids:
            email_template_name = '_notify_employee_of_refused_request'
            self._notify(cr, uid, email_template_name, send_ids)

hrself_holidays_request_leave()
