# -*- coding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2010 Tiny SPRL (<http://tiny.be>).
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import osv

class hrself_manager(osv.osv_memory):
    """Facade to high level hrself services."""

    _inherit = "hrself.manager"

    def _create_user(self, cr, uid, values):
        """Create a user.
        @return: identifier of created user
        @rtype: integer"""
        user_id = super(hrself_manager, self)._create_user(cr, uid, values)
        model_data_object = self.pool.get('ir.model.data')
        model_data_id = model_data_object._get_id(cr, uid, 'hrself_holidays', 'open_board_hrself')
        action_id = model_data_object.browse(cr, uid, model_data_id).res_id
        self.pool.get('res.users').write(cr, uid, user_id, {'action_id': action_id})
        return user_id

    def read_hrself_event_type_for_counter_type(self, cr, uid, counter_type_id, activity_context_id):
        """Read a HRSelf event type (i.e. holidays type) associated to a counter type, if any."""
        precision_object = self.pool.get('hrself.holidays.type.precision')
        precision_ids = precision_object.search(cr, uid, [('counter_type_id', '=', counter_type_id)])
        for precision in precision_object.browse(cr, uid, precision_ids):
            if precision.activity_context_id.is_compatible(activity_context_id):
                return self.pool.get('hrself.holidays.type').read(cr, uid, precision.type_id.id)
        return None

    def get_balance_for_employee(self, employee_id, holiday_type_id):
        """Get holiday time balance for a given employee and holiday type."""
        pass

hrself_manager()

# TODO complete API
