# -*- coding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2010 Tiny SPRL (<http://tiny.be>).
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

import datetime
from osv import fields,osv
from hrself import hrself_datetime

class hrself_approvement(osv.osv):
    """Approvement definition.
    This is just an abstract osv to be used by concrete ones that are defined below.
    TODO: avoid creating associated table.
    """

    _name = "hrself.approvement"

    _columns = {
        'approver_id': fields.many2one('hr.employee', 'Approver', required=True),
        'start_date': fields.date('Start date', required=True),
        'end_date': fields.date('End date'),
    }

    _defaults = {
        'start_date': hrself_datetime.to_string(datetime.date.today())
    }

    def create(self, cr, uid, values, context=None):
        """Redefined to set the user profile to human resource approver"""
        if 'approver_id' in values:
            self.pool.get('hr.employee').browse(cr, uid, values['approver_id'], context=context).user_id.set_approver_profile()
        return super(hrself_approvement, self).create(cr, uid, values, context)

    def write(self, cr, uid, ids, values, context=None):
        """Redefined to set the user profile to human resource approver"""
        if 'approver_id' in values:
            self.pool.get('hr.employee').browse(cr, uid, values['approver_id'], context=context).user_id.set_approver_profile()
        return super(hrself_approvement, self).write(cr, uid, ids, values, context)

hrself_approvement()

class hrself_employee_approvement(osv.osv):
    """Employee approvement definition."""

    _name = "hrself.employee.approvement"
    _inherit = "hrself.approvement"
    _description = "Employee approvement definition"

    _columns = {
        'employee_id': fields.many2one('hr.employee', 'Employee', required=True),
    }

hrself_employee_approvement()

class hrself_backup_approvement(osv.osv):
    """Backup approvement definition."""

    _name = "hrself.backup.approvement"
    _inherit = "hrself.approvement"
    _description = "Backup approvement definition"

    _columns = {
        'backup_approver_id': fields.many2one('hr.employee', 'Backup approver', required=True),
    }

    def create(self, cr, uid, values, context=None):
        """Redefined to set the user profile to human resource approver"""
        if 'backup_approver_id' in values:
            self.pool.get('hr.employee').browse(cr, uid, values['backup_approver_id'], context=context).user_id.set_approver_profile()
        return super(hrself_backup_approvement, self).create(cr, uid, values, context)

    def write(self, cr, uid, ids, values, context=None):
        """Redefined to set the user profile to human resource leave approver"""
        if 'backup_approver_id' in values:
            self.pool.get('hr.employee').browse(cr, uid, values['backup_approver_id'], context=context).user_id.set_approver_profile()
        return super(hrself_backup_approvement, self).write(cr, uid, ids, values, context)

hrself_backup_approvement()

class hrself_department_approvement(osv.osv):
    """Department approvement definition."""

    _name = "hrself.department.approvement"
    _inherit = "hrself.approvement"
    _description = "Department approvement definition"

    _columns = {
        'department_id': fields.many2one('hr.department', 'Department', required=True),
    }

hrself_department_approvement()
