###############################################################################
# -*- coding: utf-8 -*-
# Copyright (c) 2005-2008, Héonium SARL - Tous droits réservés
#               Christophe CRIER <contact@heonium.com> (http://heonium.com)
#
# Ce logiciel est régi par la licence CeCILL soumise au droit français et
# respectant les principes de diffusion des logiciels libres. Vous pouvez
# utiliser, modifier et/ou redistribuer ce programme sous les conditions
# de la licence CeCILL telle que diffusée par le CEA, le CNRS et l'INRIA 
# sur le site "http://www.cecill.info".
#
# En contrepartie de l'accessibilité au code source et des droits de copie,
# de modification et de redistribution accordés par cette licence, il n'est
# offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
# seule une responsabilité restreinte pèse sur l'auteur du programme,  le
# titulaire des droits patrimoniaux et les concédants successifs.
#
# A cet égard  l'attention de l'utilisateur est attirée sur les risques
# associés au chargement,  à l'utilisation,  à la modification et/ou au
# développement et à la reproduction du logiciel par l'utilisateur étant 
# donné sa spécificité de logiciel libre, qui peut le rendre complexe à 
# manipuler et qui le réserve donc à des développeurs et des professionnels
# avertis possédant  des  connaissances  informatiques approfondies.  Les
# utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
# logiciel à leurs besoins dans des conditions permettant d'assurer la
# sécurité de leurs systèmes et ou de leurs données et, plus généralement, 
# à l'utiliser et l'exploiter dans les mêmes conditions de sécurité. 
#
# Le fait que vous puissiez accéder à cet en-tête signifie que vous avez 
# pris connaissance de la licence CeCILL, et que vous en avez accepté les
# termes.
###############################################################################

import time
import subprocess
import wizard
import netsvc
import pooler
from osv.orm import browse_record

import base64
import sys,os,random
debug = True

import hnm_heofax_lib

cmd = hnm_heofax_lib.fax_cmd

def _get_reports(self, cr, uid, context):
	pool = pooler.get_pool(cr.dbname)
	user_obj = pool.get('res.users')
	user = user_obj.browse(cr, uid, uid)
	report_ids = pool.get('ir.actions.report.xml').search(cr, uid, [('model','=','purchase.order')])
	reports = [(report.report_name, report.name) for report 
		in pool.get('ir.actions.report.xml')
		.browse(cr, uid, report_ids, context={'lang': user.context_lang})]
	return reports

_fax_form = '''<?xml version="1.0"?>
<form string="Send Fax (HeoFAX)">
	<separator string="Sender informations" colspan="4"/>
	<field name="from"/>
	<field name="email"/>
	<separator string="Fax informations" colspan="4"/>
	<field name="subject" colspan="4"/>
	<newline/>
	<field name="link_coverpage" colspan="4"/>
	<newline/>
	<field name="model"/>
	<field name="recordEvent"/>
	<field name="priority"/>
	<newline/>
	<separator string="Note (Max: 20 lines)" colspan="4"/>
	<field name="note" colspan="4"/>
</form>'''

_fax_fields = {
	'from': {'string':'From (name)', 'type':'char', 'size':30, 'required':True, 'help':'Sender name for coverpage'},
	'email': {'string':'From (email)', 'type':'char', 'size':30, 'required':True, 'help':'Email for received the sending result'},
	'subject': {'string':'Subject', 'type':'char', 'size':64, 'help':'Subjet writing on corverpage (if you send your fax without coverpage this information is not required)'},
	'link_coverpage':{'string':'coverpage name','type':'many2one','relation':'hnm.heofax.coverpage'},
	'model': {
		'string':'Model',
		'type':'selection',
		'selection': _get_reports,
		'required':True,
		'default': lambda *a: 0,
		'help':'Select the model to make purchase document.'
		},
	'recordEvent': {'string':'Record event', 'type':'boolean','help':'If selected this action is added in partner\'s event.'},
	'note': {'string':'Note', 'type':'text'},
	'priority': {
		'string': 'Priority',
		'type': 'selection',
		'selection': [
			('high', 'High'), 
			('normal', 'Normal'), 
			('low', 'Low'), 
			('bulk', 'Bulk')],
		'default': lambda *a: 'normal',
	},
}

_result_form = '''<?xml version="1.0"?>
<form string="Fax result">
	<field name="fax_sent"/>
	<field name="fax_error"/>
</form>'''

_result_fields = {
	'fax_sent': {
		'string': 'Fax sent to fax server',
		'type': 'integer',
		'readonly': True,
		'help': 'This only signify the fax is transmit to fax server with success. Wait the fax server return to verify if the fax is sending with success'
		},
	'fax_error': {
		'string': 'Fax not sent to fax server',
		'type': 'integer',
		'readonly': True,
		'help': 'This number of fax isn\'t transmit to fax server. Perhaps because the fax number isn\'t given in partner form or the fax server is down'
		},
}

def _init_fields(self, cr, uid, data, context):
	pool = pooler.get_pool(cr.dbname)
	### Get general information
	# Get connected user info
	cmd['user'] = pool.get('res.users').browse(cr, uid, uid)
	# Set form field
	# search if the current user is associated to a coverpage
	# in this case this one is the value by default for the form value 'link_coverpage' 
	cr.execute("select gid from res_groups_users_rel where uid='%s'" % uid)
	res=cr.fetchone()[0]
	cr.execute("select hnm_heofax_id from hnm_heofax_group_rel where group_id='%s'" % res)
	res=cr.fetchone()
	# List coverpage affected to user
	if res:
		data['form']['link_coverpage']=pool.get('hnm.heofax.coverpage').read(cr,uid,res,['name'])[0]['id']
	data['form']['recordEvent'] = False
	# Get email address of who send FAX.
	contact = pool.get('res.partner.address').read(cr,uid,cmd['user'].address_id.id,['name','email'])
	if contact['email']:
		data['form']['email'] = contact['email']
	else:
		data['form']['email'] = cmd['email']
	data['form']['from']=contact['name']
	return data['form']

def _mass_fax_send(self, cr, uid, data, context):
	# Number of sent FAX
	nbOk = 0
	nbError = 0
	logger = netsvc.Logger()
	pool = pooler.get_pool(cr.dbname)
	
	purchase_orders = pool.get('purchase.order').browse(cr,uid,data['ids'])
	if debug: logger.notifyChannel("[HeoFAX - Debug]", netsvc.LOG_INFO, " ID(s) selected: %s" % data['ids'])
	for po in purchase_orders:
		# Get recipient name and/or company name
		if po.partner_address_id.name:
			name = po.partner_address_id.name + ' (' + po.partner_id.name + ')'
		else:
			name = po.partner_id.name
		if po.partner_address_id.fax:
			# Make purchase order and prepare for sending
			print data['form']['model']
			service = netsvc.LocalService('report.' + data['form']['model'])
			(result, format) = service.create(cr, uid, [po.id], data, context)
			fFax = "/tmp/hfx_attach" + str(random.randint(0,100))
			try:
				fc = open(fFax, "w")
				fc.write(result)
				fc.close()
			except IOError:
				raise wizard.except_wizard('[HeoFAX - Error]', 'Unable to open temporary file to prepare file attachement: %s !!!' % fFax)
			cmd['listFile'].append(fFax)
			if debug: logger.notifyChannel("[HeoFAX - Debug]", netsvc.LOG_INFO, " File attached: %s" % " ".join(cmd['listFile']))
			# Preparing other information for sending
			cmd['to_number'] = po.partner_address_id.fax
			cmd['to_company'] = po.partner_id.name
			cmd['to_name'] = name
			# Build FAX command line
			cmdFax = hnm_heofax_lib.build_fax_cmd(self, cr, uid, data, cmd)
			cmdFax = cmdFax.encode('utf8')
			if cmdFax:
				if debug:
					# For trace only
					logger.notifyChannel("[HeoFAX - Debug]", netsvc.LOG_INFO, " Fax for: %s with fax nb: %s" % (name,cmd['to_number']))
					logger.notifyChannel("[HeoFAX - Debug]",netsvc.LOG_INFO, " Command used: %s" % cmdFax)
				pipe = subprocess.Popen(cmdFax, stdout=subprocess.PIPE, 
					stderr=subprocess.PIPE, shell=True)
				sts = pipe.wait()
				out = pipe.stdout.read() + pipe.stderr.read()
				if debug:
					logger.notifyChannel("[HeoFAX - Debug]",netsvc.LOG_INFO, " ID: %d:%s" % (sts,out))
				# increment number of fax
				nbOk += 1
				# Record event if selected
				if data['form']['recordEvent']:
					ret = pool.get('res.partner.event').create(cr, uid, {'name':'Sent to FAX server \''+ po.name + '\'.', 'description': 'With report model \'' + data['form']['model'] + '\'.', 'partner_id':po.partner_id.id,'user_id':cmd['user'].id})
				# Remove working files
				for f in cmd['listFile']:
					os.remove(f)
					if debug: logger.notifyChannel("[HeoFAX - Debug]",netsvc.LOG_INFO, " Removed file: %s" % f)
				cmd['listFile'] = []
		else:
			nbError += 1
			logger.notifyChannel("[HeoFAX - Info]",netsvc.LOG_INFO, " No fax number for name: %s" % name)
	return {'fax_sent': nbOk, 'fax_error': nbError}

class send_by_fax(wizard.interface):
	states = {
		'init': {
			'actions': [_init_fields],
			'result': {'type': 'form', 'arch': _fax_form, 'fields': _fax_fields, 'state':[('send','Send Fax(s)'), ('end','Cancel')]}
		},
		'send': {
			'actions': [_mass_fax_send],
			'result': {'type':'form', 'arch':_result_form, 'fields':_result_fields, 'state':[('end','OK')]}
		}
	}
send_by_fax('purchase.order.send_by_fax')