###############################################################################
# -*- coding: utf-8 -*-
# Copyright (c) 2005-2008, Héonium SARL - Tous droits réservés
#               Christophe CRIER <contact@heonium.com> (http://heonium.com)
#
# Ce logiciel est régi par la licence CeCILL soumise au droit français et
# respectant les principes de diffusion des logiciels libres. Vous pouvez
# utiliser, modifier et/ou redistribuer ce programme sous les conditions
# de la licence CeCILL telle que diffusée par le CEA, le CNRS et l'INRIA 
# sur le site "http://www.cecill.info".
#
# En contrepartie de l'accessibilité au code source et des droits de copie,
# de modification et de redistribution accordés par cette licence, il n'est
# offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
# seule une responsabilité restreinte pèse sur l'auteur du programme,  le
# titulaire des droits patrimoniaux et les concédants successifs.
#
# A cet égard  l'attention de l'utilisateur est attirée sur les risques
# associés au chargement,  à l'utilisation,  à la modification et/ou au
# développement et à la reproduction du logiciel par l'utilisateur étant 
# donné sa spécificité de logiciel libre, qui peut le rendre complexe à 
# manipuler et qui le réserve donc à des développeurs et des professionnels
# avertis possédant  des  connaissances  informatiques approfondies.  Les
# utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
# logiciel à leurs besoins dans des conditions permettant d'assurer la
# sécurité de leurs systèmes et ou de leurs données et, plus généralement, 
# à l'utiliser et l'exploiter dans les mêmes conditions de sécurité. 
#
# Le fait que vous puissiez accéder à cet en-tête signifie que vous avez 
# pris connaissance de la licence CeCILL, et que vous en avez accepté les
# termes.
###############################################################################

import time
import subprocess
import wizard
import netsvc
import pooler
from osv.orm import browse_record

import base64
import sys,os,random
debug = True

import hnm_heofax_lib

cmd = hnm_heofax_lib.fax_cmd

_fax_form = '''<?xml version="1.0"?>
<form string="Send Fax (HeoFAX)">
	<separator string="Sender informations" colspan="4"/>
	<field name="from"/>
	<field name="email"/>
	<separator string="Fax informations" colspan="4"/>
	<field name="subject" colspan="4"/>
	<newline/>
	<field name="link_coverpage" colspan="4"/>
	<newline/>
	<field name="firstonly"/>
	<field name="recordEvent"/>
	<field name="priority"/>
	<newline/>
	<separator string="Fax attachment" colspan="4"/>
	<field name="attachment" colspan="4"/>
	<separator string="Note (Max: 20 lines)" colspan="4"/>
	<field name="note" colspan="4"/>
</form>'''

_fax_fields = {
	'from': {'string':'From (name)', 'type':'char', 'size':30, 'required':True},
	'email': {'string':'From (email)', 'type':'char', 'size':30, 'required':True},
	'subject': {'string':'Subject', 'type':'char', 'size':64, 'required':True, 'help':'Information required for add information in partner\'s event'},
	'link_coverpage':{'string':'coverpage name','type':'many2one','relation':'hnm.heofax.coverpage'},
	'firstonly': {'string':'To first contact only', 'type':'boolean', 'help':'If selected the fax will be only send to the first contact.'},
	'recordEvent': {'string':'Record event', 'type':'boolean'},
	'attachment': {'string':'Doc. PDF/PS/Text only', 'type':'binary'},
	'note': {'string':'Note', 'type':'text'},
	'priority': {
		'string': 'Priority',
		'type': 'selection',
		'selection': [
			('high', 'High'), 
			('normal', 'Normal'), 
			('low', 'Low'), 
			('bulk', 'Bulk')],
		'default': lambda *a: 'low',
	},
}

_result_form = '''<?xml version="1.0"?>
<form string="Fax result">
	<field name="fax_sent"/>
	<field name="fax_error"/>
</form>'''

_result_fields = {
	'fax_sent': {
		'string': 'Fax sent to fax server',
		'type': 'integer',
		'readonly': True,
		'help': 'This only signify the fax is transmit to fax server with success. Wait the fax server return to verify if the fax is sending with success'
		},
	'fax_error': {
		'string': 'Fax not sent to fax server',
		'type': 'integer',
		'readonly': True,
		'help': 'This number of fax isn\'t transmit to fax server. Perhaps because the fax number isn\'t given in partner form or the fax server is down'
		},
}

def _init_fields(self, cr, uid, datas, context):
	pool = pooler.get_pool(cr.dbname)
	### Get general information
	# Get connected user info
	cmd['user'] = pool.get('res.users').browse(cr, uid, uid)
	# Set form field
	# search if the current user is associated to a coverpage
	# in this case this one is the value by default for the form value 'link_coverpage' 
	cr.execute("select gid from res_groups_users_rel where uid='%s'" % uid)
	res=cr.fetchone()[0]
	cr.execute("select hnm_heofax_id from hnm_heofax_group_rel where group_id='%s'" % res)
	res=cr.fetchone()
	# List coverpage affected to user
	if res:
		datas['form']['link_coverpage']=pool.get('hnm.heofax.coverpage').read(cr,uid,res,['name'])[0]['id']
	datas['form']['firstonly'] = True
	datas['form']['recordEvent'] = False
	# Get email address of who send FAX.
	contact = pool.get('res.partner.address').read(cr,uid,cmd['user'].address_id.id,['name','email'])
	if contact['email']:
		datas['form']['email'] = contact['email']
	else:
		datas['form']['email'] = cmd['email']
	datas['form']['from']=contact['name']
	#if it's a bulk fax, set the default priority to low
	if len(datas['ids']) > 10:
		datas['form']['priority'] = 'bulk'
	#
	return datas['form']

def _send_fax(self, cr, uid, datas, context):
	# Number of sent FAX
	nbOk = 0
	nbError = 0
	logger = netsvc.Logger()
	pool = pooler.get_pool(cr.dbname)
	# Get file attachement and prepare for sending
	if datas['form']['attachment']:
		fFax = "/tmp/hfx_attach" + str(random.randint(0,100))
		try:
			fc = open(fFax, "w")
			fc.write(base64.decodestring(datas['form']['attachment']))
			fc.close()
		except IOError:
			raise wizard.except_wizard('[HeoFAX - Error]', 'Unable to open temporary file for file attachement: %s !!!' % fFax)
		cmd['listFile'].append(fFax)
		if debug: logger.notifyChannel("[HeoFAX - Debug]", netsvc.LOG_INFO, " File attached: %s" % " ".join(cmd['listFile']))

	partners = pool.get('res.partner').browse(cr, uid, datas['ids'], context)
	for partner in partners:
		for adr in partner.address:
			if adr.name:
				name = adr.name + ' (' + partner.name + ')'
			else:
				name = partner.name
			if adr.fax:
				cmd['to_number'] = adr.fax
				cmd['to_company'] = partner.name
				cmd['to_name'] = name
				# Build FAX command line
				cmdFax = hnm_heofax_lib.build_fax_cmd(self, cr, uid, datas, cmd)
				cmdFax = cmdFax.encode('utf8')
				if debug:
					# For trace only
					logger.notifyChannel("[HeoFAX - Debug]", netsvc.LOG_INFO, " Fax for: %s with fax nb: %s" % (name,cmd['to_number']))
					logger.notifyChannel("[HeoFAX - Debug]",netsvc.LOG_INFO, " Command used: %s" % cmdFax)
				pipe = subprocess.Popen(cmdFax, stdout=subprocess.PIPE, 
					stderr=subprocess.PIPE, shell=True)
				sts = pipe.wait()
				out = pipe.stdout.read() + pipe.stderr.read()
				if debug:
					logger.notifyChannel("[HeoFAX - Debug]",netsvc.LOG_INFO, " ID: %d:%s" % (sts,out))
				# increment number of fax
				nbOk += 1
				# Record event if selected
				if datas['form']['recordEvent']:
					ret = pool.get('res.partner.event').create(cr, uid, {'name':'Sent to FAX server: '+ datas['form']['subject'], 'partner_id':partner.id,'user_id':cmd['user'].id})
				# Test if sending to first contact only
				if datas['form']['firstonly']: break
			else:
				nbError += 1
				logger.notifyChannel("[HeoFAX - Info]",netsvc.LOG_INFO, " No fax number for name: %s" % name)
				if len(partners) < 1:
					raise wizard.except_wizard('[HeoFAX - Error]', ' No fax number for name: %s' % name)
		# Remove working files
	for f in cmd['listFile']:
		os.remove(f)
		if debug: logger.notifyChannel("[HeoFAX - Debug]",netsvc.LOG_INFO, " Removed file: %s" % f)
	cmd['listFile'] = []
	return {'fax_sent': nbOk, 'fax_error': nbError}

class send_fax(wizard.interface):
	states = {
		'init': {
			'actions': [_init_fields],
			'result': {'type': 'form', 'arch': _fax_form, 'fields': _fax_fields, 'state':[('send','Send Fax(s)'), ('end','Cancel')]}
		},
		'send': {
			'actions': [_send_fax],
			'result': {'type':'form', 'arch':_result_form, 'fields':_result_fields, 'state':[('end','OK')]}
		}
	}
send_fax('res.partner.send_fax')
