#!/usr/bin/python
# -<strong class="bold">- coding: utf-8 -</strong>-
################################################################################

import string,os,ftplib

def get_exdesc(excpt):
	if type(excpt.args) == type(''):
		return excpt.args
	elif type(excpt.args) == type(()):
		return excpt.args[-1]
	else:
		return str(excpt)

class Hylafax:
	retrbuf = []
	filepath = ""
	coverpath = ""
	username = "Anonymous"
	password = ''
	adminpass = ''
	parmhash = {}
	sendhash = {}
	multicover = 0
	cover_as_document = 0
	recvfile = ''
	ftpexcpt = None
	filerror = None
	tzone = 0

	def __init__(self,host='',port=4559, debug=0, passive=1):
		self.debug = debug
		self.ftp = ftplib.FTP()
		self.ftp.set_pasv(passive)
		self.setfaxhost(host,port)

	def callback(self,str):
		self.retrbuf.append(str)

	def setfaxhost(self,host,port):
		hosterr = "Parameter 'host' must be a string."
		porterr = "Parameter 'port' must be an integer."
		if type(host) == type(""):
			self.faxhost = host
		else:
			try:
				self.faxhost = str(host)
			except:
				raise hosterr
		if type(port) == type(1):
			self.faxport = port
		else:
			raise porterr

	def login(self,ftpobj,username,password,adminpass):
		try:
			#self.debug = 2
			self.ftp.set_debuglevel(self.debug)
			ftpobj.sendcmd('USER '+username)
        
			if password:
				ftpobj.sendcmd('PASS '+password)
			if adminpass:
				ftpobj.sendcmd('ADMIN '+adminpass)
		except (ftplib.error_perm, ftplib.error_temp), msg:
			#Hide the "already logged in" error
			if not str(msg).startswith("503"): 
				print "Already logged", msg
		except Exception, msg:
			print "Error on login!", msg
			msg = get_exdesc(msg)
			return (1, msg)

		if self.tzone == 0: tzoneCmd = 'GMT'
		else: tzoneCmd = 'LOCAL'
    
		ftpobj.sendcmd('TZONE %s' % tzoneCmd)
		ftpobj.sendcmd('MODE S')
    
		return (0, 'ok')

	def getstatus(self):
		try:
			self.ftp.connect(self.faxhost,self.faxport)
		except Exception, msg:
			msg = get_exdesc(msg)
			return (0, msg)
		try:
			self.login(self.ftp,self.username,self.password,self.adminpass)
		except Exception, msg:
			msg = get_exdesc(msg)
			return (1, msg)
		self.retrbuf = []
		self.ftp.retrlines('LIST status', self.callback)
		self.ftp.quit()
		return (0, self.retrbuf)

def sndfax(self,lst_file, param, coverpage=None):
	"""
	"""
	param = dict( ( (k.upper(), v) for k, v in param.iteritems() ) )
      
	try:
		self.ftp.connect(self.faxhost,self.faxport)
	except Exception, msg:
		msg = get_exdesc(msg)
		return (1, msg)
	self.login(self.ftp,self.username,self.password,self.adminpass)
	if type(lst_file) is not LT:
		files = []
		files.append(lst_file)
	else:
		files = lst_file
	file2snd = []

	fileNotexits = filter( lambda x: not os.path.exists(x), files )

	if fileNotexits:
		return (1, "This files not exists: %s" % str(fileNotexits) )

	#send the cover, if need
	cover_name = ""
        
	if coverpage:
		self.ftp.sendcmd('FORM PS')
		try:
			fd = SendFile(coverpage.make_cover_path())
			cover_name = self.ftp.storbinary('STOT', fd)
			cover_name = self._extract_filename(cover_name)
		except Exception, msg:
			msg = get_exdesc(msg), coverpage
			print "Error send cover!", msg
			return (1, msg)

	for file in files:
		#Send multiple documents
		f = open(file)
		header = f.read(4)
		f.close()
		if header == "%!PS":
			self.ftp.sendcmd('FORM PS')
		elif header == "%PDF":
			self.ftp.sendcmd('FORM PS')
		else:
			self.ftp.sendcmd('FORM TIFF')
		try:
			fd = SendFile(file)
		except Exception, msg:
			print "Error on send file", file, msg
			msg = get_exdesc(msg)
			return (1, msg)
		file2snd.append(self.ftp.storbinary('STOT',fd,10240))

	for k, def_val in  (("vres","196"),
			("pagewidth","209"),("pagelength","296"),
			("pagechop","default"),("chopthreshold","3"),):
		k = k.upper()

		if not k in param:
			param[k] = def_val

	jobl = []
	try:
		self.ftp.sendcmd('JNEW')
		for jparm, jval in param.iteritems():
			if not isinstance(jval, basestring):
				jval = str(jval)
			if not jval.strip():
				continue

			self.ftp.sendcmd('JPARM %s %s' % (jparm, jval))
            
		#send the conver name, if need
		if coverpage:
			self.ftp.sendcmd('JPARM %s %s' % ('COVER', cover_name))

		#send the filename
		for file in file2snd:
			filename = self._extract_filename(file)
			self.ftp.sendcmd('JPARM %s %s' % ('DOCUMENT', filename))

		self.ftp.sendcmd('JSUBM')
		self.ftp.quit()
	except:
		msg = traceback.format_exc()
		print 'Error on send fax', msg
		return (1, msg)
	return (0, 'ok')

if __name__ == '__main__': #This is a script
	h = Hylafax('192.168.13.20')
	h.username = "cch"
	print h.getstatus()
