###############################################################################
# -*- coding: utf-8 -*-
# Copyright (c) 2005-2008, Héonium SARL - Tous droits réservés
#               Christophe CRIER <contact@heonium.com> (http://heonium.com)
#
# Ce logiciel est régi par la licence CeCILL soumise au droit français et
# respectant les principes de diffusion des logiciels libres. Vous pouvez
# utiliser, modifier et/ou redistribuer ce programme sous les conditions
# de la licence CeCILL telle que diffusée par le CEA, le CNRS et l'INRIA 
# sur le site "http://www.cecill.info".
#
# En contrepartie de l'accessibilité au code source et des droits de copie,
# de modification et de redistribution accordés par cette licence, il n'est
# offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
# seule une responsabilité restreinte pèse sur l'auteur du programme,  le
# titulaire des droits patrimoniaux et les concédants successifs.
#
# A cet égard  l'attention de l'utilisateur est attirée sur les risques
# associés au chargement,  à l'utilisation,  à la modification et/ou au
# développement et à la reproduction du logiciel par l'utilisateur étant 
# donné sa spécificité de logiciel libre, qui peut le rendre complexe à 
# manipuler et qui le réserve donc à des développeurs et des professionnels
# avertis possédant  des  connaissances  informatiques approfondies.  Les
# utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
# logiciel à leurs besoins dans des conditions permettant d'assurer la
# sécurité de leurs systèmes et ou de leurs données et, plus généralement, 
# à l'utiliser et l'exploiter dans les mêmes conditions de sécurité. 
#
# Le fait que vous puissiez accéder à cet en-tête signifie que vous avez 
# pris connaissance de la licence CeCILL, et que vous en avez accepté les
# termes.
###############################################################################

import pooler
import wizard
import os

from tools.config import config

# [TODO] - Put these informations in administration panel.
fax_cmd = {
	'user': None,
	'host': ' -h 192.168.13.20',
	'email': 'contact@heonium.com',
	'from': '',
	'sendFax': 'sendfax',
	'faxCover': 'faxcover',
	'notifySender': ' -D',
	'pageSize': ' -s a4',
	'coverPage': ' -n',
	'maxlencomments': ' -z 83',
	'subject': '',
	'comment': '',
	'to_number': '',
	'to_company': '',
	'to_name':'',
	'listFile': [],
	}

# [TODO] using a real python api for sending fax 
def build_fax_cmd(self, cr, uid, datas, tx_cmd):
	""" Affecting 'tx_cmd' dictionnary with values collected by form and build the line command used to send FAX.
	"""
	pool = pooler.get_pool(cr.dbname)
	attachement = True
	# Create sender info 
	tx_cmd['from'] = ' -f \"' + tx_cmd['user'].name + ' <' + datas['form']['email'] + '>\"'
	# Update 'comment' info if exist 
	if datas['form']['note']:
		tx_cmd['comment'] = ' -c \"' + datas['form']['note'].decode('utf8') + '\"'
	# Update 'subject' info if exist
	if datas['form']['subject']:
		tx_cmd['subject'] = ' -r \"' + datas['form']['subject'].decode('utf8') + '\"'
	if tx_cmd['to_number']:
		tx_cmd['to_number'] = tx_cmd['to_number'].replace('(','').replace('33)0','33.')
	if tx_cmd['to_company']:
		tx_cmd['to_company'] = ' -x \"' + tx_cmd['to_company'] + '\"'
	if datas['form']['link_coverpage']:
		# If coverpage selected : prepare command line
		adp = os.path.abspath(config['addons_path'])
		tx_cmd['coverPage'] = ' -C ' + os.path.normcase(os.path.join(
			adp, 'hnm_heofax', 'coverpage', 
			str(pool.get('hnm.heofax.coverpage').read(cr, uid, 
			str(datas['form']['link_coverpage']), ['name'])[0]['name'])))
	tx_cmd['priority'] = ''
	if datas['form']['priority']:
		tx_cmd['priority'] = ' -P ' + datas['form']['priority']
	if tx_cmd['listFile']:
		if tx_cmd['coverPage'] == ' -n':
			# command line for fax with no coverpage and attachement
			command = tx_cmd['sendFax'] + tx_cmd['priority'] + tx_cmd['notifySender'] + tx_cmd['pageSize'] + tx_cmd['host'] + tx_cmd['from'] + tx_cmd['coverPage'] + ' -d \"' + tx_cmd['to_name'] + '@' + tx_cmd['to_number'] + '\" ' + " ".join(tx_cmd['listFile'])
		else:
			# command line for fax with coverpage and attachement
			command = tx_cmd['sendFax'] + tx_cmd['priority'] + tx_cmd['notifySender'] + tx_cmd['pageSize'] + tx_cmd['host'] + tx_cmd['coverPage'] + tx_cmd['subject'] + tx_cmd['from'] + tx_cmd['comment'] + tx_cmd['to_company'] + ' -d \"' + tx_cmd['to_name'] + '@' + tx_cmd['to_number'] + '\" ' + " ".join(tx_cmd['listFile'])
	else:
		if tx_cmd['coverPage'] == ' -n':
			raise wizard.except_wizard('[HeoFAX - Info]', 'NO coverpage and NO attachement to send !!!')
			return ''
		else:
			# command line for fax with coverpage only
			command = tx_cmd['faxCover'] + tx_cmd['pageSize'] + tx_cmd['maxlencomments'] + tx_cmd['coverPage'] + tx_cmd['subject'] + tx_cmd['comment'] + tx_cmd['from'] + tx_cmd['to_company'] + ' -t \"' + tx_cmd['to_name'] + '\" -n \"' + tx_cmd['to_number'] + '\" | ' + tx_cmd['sendFax'] + tx_cmd['priority'] + tx_cmd['host'] + tx_cmd['notifySender'] + tx_cmd['pageSize'] + ' -n' + ' -d \"' + tx_cmd['to_name'] + '@' + tx_cmd['to_number'] + '\" '
	return command