###############################################################################
# -*- coding: utf-8 -*-
# Copyright (c) 2005-2008, Héonium SARL - Tous droits réservés
#               Christophe CRIER <contact@heonium.com> (http://heonium.com)
#               Baptiste CLENCHARD <contact@heonium.com> (http://heonium.com)
#
# Ce logiciel est régi par la licence CeCILL soumise au droit français et
# respectant les principes de diffusion des logiciels libres. Vous pouvez
# utiliser, modifier et/ou redistribuer ce programme sous les conditions
# de la licence CeCILL telle que diffusée par le CEA, le CNRS et l'INRIA 
# sur le site "http://www.cecill.info".
#
# En contrepartie de l'accessibilité au code source et des droits de copie,
# de modification et de redistribution accordés par cette licence, il n'est
# offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
# seule une responsabilité restreinte pèse sur l'auteur du programme,  le
# titulaire des droits patrimoniaux et les concédants successifs.
#
# A cet égard  l'attention de l'utilisateur est attirée sur les risques
# associés au chargement,  à l'utilisation,  à la modification et/ou au
# développement et à la reproduction du logiciel par l'utilisateur étant 
# donné sa spécificité de logiciel libre, qui peut le rendre complexe à 
# manipuler et qui le réserve donc à des développeurs et des professionnels
# avertis possédant  des  connaissances  informatiques approfondies.  Les
# utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
# logiciel à leurs besoins dans des conditions permettant d'assurer la
# sécurité de leurs systèmes et ou de leurs données et, plus généralement, 
# à l'utiliser et l'exploiter dans les mêmes conditions de sécurité. 
#
# Le fait que vous puissiez accéder à cet en-tête signifie que vous avez 
# pris connaissance de la licence CeCILL, et que vous en avez accepté les
# termes.
###############################################################################

from osv import fields,osv,orm
from tools.config import config
import os, sys, string

def nameFilter(str): return str.endswith('-tpl.ps')

#### _coverpage_get
# Return a list of coverpage with pattern :
# 	xxx-tpl.ps
def _coverpage_get(self, cr, uid, context={}):
	adp = os.path.abspath(config['addons_path'])
	dirCoverpage = os.path.normcase(os.path.join(adp, 'hnm_heofax', 'coverpage'))
	listCoverpage = [
		(os.path.normcase(lc), lc.replace('_',' ').replace('-tpl.ps', '')) 
		for lc in filter(nameFilter, os.listdir(dirCoverpage))
	]
	return listCoverpage

class hnm_heofax_coverpage(osv.osv):
	_name="hnm.heofax.coverpage"
	_columns={
		'name': fields.selection(_coverpage_get, 'Coverpage name', size=64, required=True),
		'group':fields.many2many('res.groups','hnm_heofax_group_rel','hnm_heofax_id','group_id','Group associated'),
	}
hnm_heofax_coverpage()