# -*- encoding: utf-8 -*-
##############################################################################
#
#    Avanzosc - Avanced Open Source Consulting
#    Copyright (C) 2011 - 2012 Avanzosc <http://www.avanzosc.com>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see http://www.gnu.org/licenses/.
#
##############################################################################

from osv import fields,osv
from tools.translate import _

import wizard
import pooler

class wizard_stock_delivery_extra(wizard.interface):

    def exist_purchase_order(self, cr, uid, data, context, ref):
        pool = pooler.get_pool(cr.dbname)
        purchase_order_objs = pool.get('purchase.order')
        ids = purchase_order_objs.search(cr, uid, [('origin', 'like', ref)])
        
        if ids != []:
            return ids[0]
        return False
    
    def mount_purchase_order_line(self, cr , uid, stock_moves):
        pool = pooler.get_pool(cr.dbname)
        delivery_carrier_objs = pool.get('delivery.carrier')
        delivery_carriers = delivery_carrier_objs.browse(cr, uid, delivery_carrier_objs.search(cr, uid, []))
        
        delivery= {
                'carrier': None,
                'stock_line': None,
                #'notes': '',
        }
        for stock_move in stock_moves:
            for delivery_carrier in delivery_carriers:
                if stock_move.product_id == delivery_carrier.product_id:
                    delivery['carrier'] = delivery_carrier
                    delivery['stock_line'] = stock_move
#                else:
#                    delivery['notes'] += '{name}\t{qty}\t{uom}\n'.format(name=stock_move.product_id.name, qty=stock_move.product_qty, uom=stock_move.product_uom.name)
        return delivery
    
    def get_price(self, cr, uid, id, stock, context):
        pool = pooler.get_pool(cr.dbname)
        delivery_objs = pool.get('delivery.carrier')
        total = 0
        weight = 0
        volume = 0

        for line in stock.move_lines:
            carrier = False
            if not line.product_id:
                continue
            for delivery in delivery_objs.browse(cr, uid, delivery_objs.search(cr, uid, [])):
                if line.product_id.id == delivery.product_id.id:
                    carrier = True
            if not carrier:
                qty = line.product_qty
                weight += (line.product_id.weight or 0.0) * qty
                volume += (line.product_id.volume or 0.0) * qty
                
        return self.get_price_from_picking(cr, uid, id, weight, volume, context)
    
    def get_price_from_picking(self, cr, uid, id, weight, volume, context={}):
        pool = pooler.get_pool(cr.dbname)
        grid = pool.get('delivery.grid').browse(cr, uid, id, context)
        
        price = 0.0
        ok = False

        for line in grid.line_ids:
            price_dict = {'price': price, 'volume':volume, 'weight': weight, 'wv':volume*weight}
            test = eval(line.type+line.operator+str(line.max_value), price_dict)
            if test:
                price = line.standard_price
                if line.price_type=='variable':
                    price *= price_dict[line.variable_factor]
                ok = True
                break
        if not ok:
            raise osv.except_osv(_('No price avaible !'), _('No line matched this order in the choosed delivery grids !'))
        return price
    
    def create_sale_order(self, cr, uid, data, context):
        pool = pooler.get_pool(cr.dbname)
        stock_pick = pool.get('stock.picking').browse(cr, uid, data['ids'])[0]
        warehouse_obj = pool.get('stock.warehouse')
        warehouse = warehouse_obj.browse(cr, uid, warehouse_obj.search(cr, uid, []))[0]
        purchase_order_objs = pool.get('purchase.order')
        stock_move_objs = pool.get('stock.move')
        grid_objs = pool.get('delivery.grid')
        carrier_obj = pool.get('delivery.carrier')
        stock_moves = stock_move_objs.browse(cr, uid, stock_move_objs.search(cr, uid, [('picking_id','=', stock_pick.id)]))
        reference = stock_pick.name + ':' + stock_pick.origin
        
        delivery = self.mount_purchase_order_line(cr, uid, stock_moves)
        if not delivery['carrier']:
            raise osv.except_osv(_('User error'), _('There is no delivery carrier !'))
        if not delivery['carrier'].partner_id.address[0]:
            raise osv.except_osv(_('Error'), _('The carrier has not any address associated !'))
        if not delivery['carrier'].partner_id.property_product_pricelist_purchase:
            raise osv.except_osv(_('Error'), _('The carrier has not any purchase price list associated !'))
        
        grid = carrier_obj.grid_get(cr, uid, [delivery['carrier'].id], stock_pick.address_id.id, context)
        if not grid:
            raise osv.except_osv(_('Error'), _('No delivery grid found !'))
        
        valueOrder = {
                'origin': reference,
                'partner_id': delivery['carrier'].partner_id.id,
                'partner_address_id': delivery['carrier'].partner_id.address[0].id,
                'pricelist_id': delivery['carrier'].partner_id.property_product_pricelist_purchase.id,
                'location_id': warehouse.lot_input_id.id,
#                'notes': delivery['notes']
        }
        
        valueLine = {
                'name': '%s - %s : %s KG' % (delivery['stock_line'].name, stock_pick.address_id.partner_id.name, stock_pick.weight),
                'product_qty': 1,
                'product_uom': delivery['stock_line'].product_uom.id,
                'product_id': delivery['stock_line'].product_id.id,
                'date_planned': delivery['stock_line'].date_planned,
                'price_unit': self.get_price(cr, uid, grid, stock_pick, context),
        }
        
        taxes = []
        for tax in delivery['stock_line'].product_id.supplier_taxes_id:
            taxes.append(tax.id)
        
        id = self.exist_purchase_order(cr, uid, data, context, reference)
        
        if id == False: 
            valueLine['order_id'] = purchase_order_objs.create(cr, uid, valueOrder)
            id = pool.get('purchase.order.line').create(cr, uid, valueLine)
            pool.get('purchase.order.line').write(cr, uid, id, {'taxes_id': [(6, 0, taxes)]})   
        else:
            purchase_order_objs.write(cr, uid, id, valueOrder)
            id_line = pool.get('purchase.order.line').search(cr, uid, [('order_id','=',id)])
            pool.get('purchase.order.line').write(cr, uid, id_line, valueLine)
            pool.get('purchase.order.line').write(cr, uid, id_line, {'taxes_id': [(6, 0, taxes)]})
        return {}
    
    states = {
        'init': {
            'actions': [create_sale_order],
            'result': {
                'type': 'form', 
                'arch' : """<?xml version="1.0"?>
                            <form string="Delivery order">
                            <separator string="Delivery order done !" />
                            </form>""",
                'fields' : {}, 
                'state' : [('end', 'Ok')]
            }
        },
    }
wizard_stock_delivery_extra('stock.delivery.extra')
