# -*- encoding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2010-2012 ASPerience SARL (<http://www.asperience.fr>).
#    All Rights Reserved
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################


import netsvc
import logging
import pooler
import datetime, time
from osv import fields, osv, orm
from tools.translate import _
import decimal_precision as dp
import logging
from pprint import pprint
from tools import DEFAULT_SERVER_DATETIME_FORMAT

class sale_shop(osv.osv):
    _name = 'sale.shop'
    _inherit = 'sale.shop'
    
    _columns = {
    }
    _defaults = {
    }
sale_shop()

class sale_order(osv.osv):
    _name = 'sale.order'
    _inherit = 'sale.order'
    
    def copy(self, cr, uid, id, default=None,context={}):
        if not default:
            default = {}
        default.update({
            'invoice_commission_id': False,
        })
        return super(sale_order, self).copy(cr, uid, id, default, context)
    
    def action_done(self, cr, uid, ids, *args):
        commission_obj = self.pool.get('hr.employee.commission')
        for commission_id in commission_obj.search(cr, uid, [('sale_order_id','in', ids)]):
            commission_obj.write(cr, uid, commission_id, {'state': 'done'})
        return ids
    
    def action_ship_create(self, cr, uid, ids, context=None):
        res = super(sale_order, self).action_ship_create(cr, uid, ids, context)
        for order in self.browse(cr, uid, ids, context=context):
            if order.partner_commission_id:
                self._make_invoice_commission(cr, uid, [order.id])
                
            if order.user_id and order.seller_total_commission:
                seller_commission = self.pool.get('hr.employee').get_employee_by_user(cr, uid, order.user_id.id)
                if seller_commission:
                    commission = {
                        'date': datetime.datetime.now(), 
                        'state': 'draft', 
                        'sale_order_id': order.id,
                        'employee_id': seller_commission.id, 
                        'amount': order.seller_total_commission
                    }
                    self.pool.get('hr.employee.commission').create(cr, uid, commission)
                
            if order.employee_commission_id and order.employee_total_commission:
                employee_commission = self.pool.get('hr.employee').get_employee_by_user(cr, uid, order.employee_commission_id.id)
                if employee_commission:
                    commission = {
                        'date': datetime.datetime.now(), 
                        'state': 'draft', 
                        'sale_order_id': order.id,
                        'employee_id': employee_commission.id, 
                        'amount': order.employee_total_commission
                    }
                    self.pool.get('hr.employee.commission').create(cr, uid, commission)
        return res
    
    def _get_order(self, cr, uid, ids, context=None):
        result = {}
        for line in self.pool.get('sale.order.line').browse(cr, uid, ids, context=context):
            result[line.order_id.id] = True
        return result.keys()
    
    def _make_invoice_commission(self, cr, uid, ids, context={}, states=['draft']):
        for order in self.browse(cr, uid, ids):
            if not order.invoice_commission_id and order.partner_commission_id and order.partner_total_commission:
                if not order.company_id:
                    raise osv.except_osv(_('Error :'), _("No company defined"))
                if not order.company_id.account_commission_id:
                    raise osv.except_osv(_('Error :'), _("No account commission defined on company"))
                
                data_invoice = {
                    'name': _('Commission Invoice %s')% order.name,
                    'origin': order.name,
                    'type': 'in_invoice',
                    'account_id': order.partner_commission_id.property_account_receivable.id,
                    'partner_id': order.partner_commission_id.id,
                    'address_invoice_id': order.partner_invoice_id.id,
                    'address_contact_id': order.partner_order_id.id,
                    'currency_id': order.pricelist_id.currency_id.id,
                    'comment': order.note,
                    #'payment_term': order.payment_term.id or False,
                    'fiscal_position': order.partner_commission_id.property_account_position.id
                }
                invoice_id = self.pool.get('account.invoice').create(cr, uid, data_invoice)
                for order_line in order.order_line:
                    if order_line.partner_commission:
                        inv_line_id = self.pool.get('account.invoice.line').create(cr, uid, {
                            'name': _('Commission %s')% order_line.name,
                            'product_id': order_line.product_id.id,
                            'account_id': order.company_id.account_commission_id.id ,
                            'quantity': 1,
                            'price_unit': order_line.partner_commission,
                            'invoice_id': invoice_id,
#                            'invoice_line_tax_id': [(6, 0, ,?)]
                        })
                if order.partner_amount_commission:
                    inv_line_id = self.pool.get('account.invoice.line').create(cr, uid, {
                        'name': _('Global Commission'),
#                        'product_id': order_line.product_id.id,
                        'account_id': order.company_id.account_commission_id.id ,
                        'quantity': 1,
                        'price_unit': order.partner_amount_commission,
                        'invoice_id': invoice_id,
#                        'invoice_line_tax_id': [(6, 0, ,?)]
                    })
                    
                self.write(cr, uid, [order.id], {'invoice_commission_id': invoice_id})
        return True

    def get_partner_commission(self, cr, uid, ids, context=False):
        if not ids:
            for res_user_obj in self.pool.get('res.users').browse(cr, uid, [uid]):
                address_id = res_user_obj.company_id.id
                for res_partner_address_obj in self.pool.get('res.company').browse(cr, uid, [address_id]):
                    result = res_partner_address_obj.partner_id.id
        else:
            for order in self.browse(cr,uid, ids):
                for res_user_obj in self.pool.get('res.users').browse(cr, uid, [order.create_uid.id]):
                    address_id = res_user_obj.company_id.id
                    for res_partner_address_obj in self.pool.get('res.company').browse(cr, uid, [address_id]):
                        result = res_partner_address_obj.partner_id.id
        return result
    
    def onchange_partner_id(self, cr, uid, ids, part):
        result = super(sale_order, self).onchange_partner_id(cr, uid, ids, part)
        shop = False
        result['value']['rebate_percent'] = 0.0
        result['value']['user_id'] = uid
        if part:
            partner = self.pool.get('res.partner').browse(cr, uid, part)
            if partner.customer_type == 'direct':
                res = self.get_partner_commission(cr, uid, ids)
                result['value']['partner_commission_id'] = res
            result['value']['rebate_percent'] = partner.rebate_percent or 0.0

            if partner.department_id:
                result['value']['department_id'] = partner.department_id.id
                if partner.department_id.manager_id:
                    result['value']['user_id'] = partner.department_id.manager_id.id

            if partner.user_id:
                result['value']['user_id'] = partner.user_id.id
                
        elif shop:
            if shop.project_id.id:
                result['value']['project_id'] = shop.project_id.id
            if shop.pricelist_id.id:
                result['value']['pricelist_id'] = shop.pricelist_id.id
            if shop.payment_default_id.id:
                result['value']['payment_term'] = shop.payment_default_id.id
            
        return result
    
    def onchange_shipping_id(self, cr, uid, ids, part, shop_id):
        result = {'value': {'partner_commission_id': False}}        
        if part:
            partner = self.pool.get('res.partner').browse(cr, uid, part)
            if partner.customer_type == 'executive_contract':
                res = self.get_partner_commission(cr, uid, ids)
                result['value']['partner_commission_id'] = res
        return result               
        
    def onchange_partner_commission_id(self, cr, uid, ids, partner_commission_id):
        result = {'value': {'partner_percent_commission': 0.0}}
        if partner_commission_id:
            partner_commission = self.pool.get('res.partner').browse(cr, uid, partner_commission_id)
            if partner_commission:
                result['value']['partner_percent_commission'] = partner_commission.commission_global_percent or 0.0
        orders = self.pool.get('sale.order').browse(cr, uid, ids)
        for order in orders:
            results_amount = order._amount_all([],False,False)
        return result
    
    def onchange_employee_commission_id(self, cr, uid, ids, employee_commission_id):
        result = {'value': {'employee_percent_commission': 0.0}}
        if employee_commission_id:
            employee_commission = self.pool.get('hr.employee').get_employee_by_user(cr, uid, employee_commission_id)
            if employee_commission:
                result['value']['employee_percent_commission'] = employee_commission.commission_global_percent or 0.0
        orders = self.pool.get('sale.order').browse(cr, uid, ids)
        for order in orders:
            results_amount = order._amount_all([],False,False)
        return result
    
    def onchange_seller_commission_id(self, cr, uid, ids, seller_commission_id):
        result = {'value': {'seller_percent_commission': 0.0}}
        if seller_commission_id:
            seller_commission = self.pool.get('hr.employee').get_employee_by_user(cr, uid, seller_commission_id)
            if seller_commission:
                result['value']['seller_percent_commission'] = seller_commission.commission_global_percent or 0.0
        orders = self.pool.get('sale.order').browse(cr, uid, ids)
        for order in orders:
            results_amount = order._amount_all([],False,False)
        return result
    
    def _get_option(sale_option):
        def get_option(self, cr, uid, context={}):
            partner_id = context.get('partner_id', False) 
            use_partner_configuration = False
            if partner_id:
                partner = self.pool.get('res.partner').read(cr, uid, [partner_id], [sale_option,'use_partner_configuration'])
                if partner['use_partner_configuration']:
                    use_partner_configuration = True
                    if sale_option in partner[0]:
                        return partner[0][sale_option]
                    else: 
                        return False
    
            if not use_partner_configuration:
                company_id = self.pool.get('res.users').browse(cr, uid, uid, context).company_id.id
                company = self.pool.get('res.company').read(cr, uid, [company_id], [sale_option])
                if sale_option in company[0]:
                    return company[0][sale_option]
                else: 
                    return False
        return get_option

    def _amount_all(self, cr, uid, ids, field_name, arg, context):
        res = {}
        cur_obj = self.pool.get('res.currency')
        company = self.pool.get('res.users').browse(cr, uid, uid).company_id
        for order in self.browse(cr, uid, ids):
            res[order.id] = {
                'amount_untaxed_wo_rebate': 0.0,
                'amount_rebate': 0.0,
                'amount_untaxed': 0.0,
                'amount_tax': 0.0,
                'amount_total': 0.0,
                'partner_total_commission': 0.0,
                'partner_lines_commission': 0.0,
                'partner_amount_commission': 0.0,
                'employee_total_commission': 0.0,
                'employee_lines_commission': 0.0,
                'employee_amount_commission': 0.0,
                'seller_total_commission': 0.0,
                'seller_lines_commission': 0.0,
                'seller_amount_commission': 0.0,
            }

            val = val1 = val2 = val3 = val4 = val5 = val6 = 0.0
            partner_com = employee_com = seller_com = 0.0
            cur = order.pricelist_id.currency_id
            line_ids = []
            for line in order.order_line:
                result = line._margin([],arg,context)
                self.pool.get('sale.order.line').write(cr, uid, line.id, result[line.id])
                val1 += line.price_subtotal
                rebate = cur_obj.round(cr, uid, cur, line.price_subtotal * (order.rebate_percent or 0.0)/100.0)
                price_subtotal = line.price_subtotal - rebate
                val2 += price_subtotal
                val3 += rebate
                if not line.cost_price:
                    if line.product_id:
                        cost_price = line.product_id.standard_price
                    else:
                        cost_price = line.price_unit * company.coef_standard_marge
                else:
                    cost_price = line.cost_price
                cost = cur_obj.round(cr, uid, cur, cost_price * line.product_uom_qty) 
                val4 += price_subtotal - cost
                val5 += cost
#                for c in self.pool.get('account.tax').compute(cr, uid, line.tax_id, line.price_unit * (1-(line.discount or 0.0)/100.0)* (1-(order.rebate_percent or 0.0)/100.0), line.product_uom_qty, line.order_id.partner_invoice_id.id, line.product_id, line.order_id.partner_id):
#                    val += c['amount']
                val += self._amount_line_tax(cr, uid, line, context=context)
                if line.partner_commission:
                    partner_com += line.partner_commission
                if line.employee_commission:
                    employee_com += line.employee_commission
                if line.seller_commission:
                    seller_com += line.seller_commission
            res[order.id]['amount_margin'] = cur_obj.round(cr, uid, cur, val4)
            res[order.id]['amount_cost'] = cur_obj.round(cr, uid, cur, val5)
            res[order.id]['amount_untaxed_wo_rebate'] = cur_obj.round(cr, uid, cur, val1)
            res[order.id]['amount_rebate'] = cur_obj.round(cr, uid, cur, val3)
            res[order.id]['amount_tax'] = cur_obj.round(cr, uid, cur, val)
            res[order.id]['amount_untaxed'] = cur_obj.round(cr, uid, cur, val2)
            res[order.id]['amount_total'] = res[order.id]['amount_untaxed'] + res[order.id]['amount_tax']
            
            commissions = 0.0
            net_margin = val4
            
            # Commission partenaire
            if order.partner_commission_id:
                res[order.id]['partner_lines_commission'] = cur_obj.round(cr, uid, cur, partner_com)
                if order.partner_commission_id.commission_type == "brut":
                    res[order.id]['partner_amount_commission'] = cur_obj.round(cr, uid, cur, val2 * (order.partner_percent_commission or 0.0) /100)
                elif order.partner_commission_id.commission_type == "brut_margin":
                    res[order.id]['partner_amount_commission'] = cur_obj.round(cr, uid, cur, val4 * (order.partner_percent_commission or 0.0) /100)
                else:
                    res[order.id]['partner_amount_commission'] = cur_obj.round(cr, uid, cur, net_margin * (order.partner_percent_commission or 0.0) /100)

                res[order.id]['partner_total_commission'] = res[order.id]['partner_amount_commission'] + res[order.id]['partner_lines_commission']
                commissions += res[order.id]['partner_total_commission']
                net_margin -= res[order.id]['partner_total_commission']
            
            # Commission employé
            if order.employee_commission_id:
                employee_commission = self.pool.get('hr.employee').get_employee_by_user(cr, uid, order.employee_commission_id.id)
                if employee_commission:
                    res[order.id]['employee_lines_commission'] = cur_obj.round(cr, uid, cur, employee_com)
                    if employee_commission.commission_type == "brut":
                        res[order.id]['employee_amount_commission'] = cur_obj.round(cr, uid, cur, val2 * (order.employee_percent_commission or 0.0) /100)
                    elif employee_commission.commission_type == "brut_margin":
                        res[order.id]['employee_amount_commission'] = cur_obj.round(cr, uid, cur, val4 * (employee_commission.commission_global_percent or 0.0) /100)
                    else:
                        res[order.id]['employee_amount_commission'] = cur_obj.round(cr, uid, cur, net_margin * (employee_commission.commission_global_percent or 0.0) /100)
                        
                    res[order.id]['employee_total_commission'] = res[order.id]['employee_amount_commission'] + res[order.id]['employee_lines_commission']
                    commissions += res[order.id]['employee_total_commission']

            # Commission vendeur
            if order.user_id:
                seller_commission = self.pool.get('hr.employee').get_employee_by_user(cr, uid, order.user_id.id)
                if seller_commission:
                    res[order.id]['seller_lines_commission'] = cur_obj.round(cr, uid, cur, seller_com)
                    if seller_commission.commission_type == "brut":
                        res[order.id]['seller_amount_commission'] = cur_obj.round(cr, uid, cur, val2 * (order.seller_percent_commission or 0.0) /100)
                    elif seller_commission.commission_type == "brut_margin":
                        res[order.id]['seller_amount_commission'] = cur_obj.round(cr, uid, cur, val4 * (order.seller_percent_commission or 0.0) /100)
                    else:
                        res[order.id]['seller_amount_commission'] = cur_obj.round(cr, uid, cur, net_margin * (order.seller_percent_commission or 0.0) /100)
                    
                    res[order.id]['seller_total_commission'] = res[order.id]['seller_amount_commission'] + res[order.id]['seller_lines_commission']
                    commissions += res[order.id]['seller_total_commission']
            
            res[order.id]['commissions'] = commissions
            res[order.id]['amount_cost_net'] = val5 + commissions 
            net_margin = val4 - commissions
            res[order.id]['amount_margin_net'] = net_margin

            if res[order.id]['amount_untaxed']:
                res[order.id]['margin'] = cur_obj.round(cr, uid, cur, (1-(res[order.id]['amount_cost']/res[order.id]['amount_untaxed']))*100)
                res[order.id]['margin_net'] = cur_obj.round(cr, uid, cur, (1-(res[order.id]['amount_cost_net']/res[order.id]['amount_untaxed']))*100)
            else:
                res[order.id]['margin'] = -100.0
                res[order.id]['margin_net'] = -100.0

        return res

    _columns = {
        'rebate_percent': fields.float('Rebate (%)', digits=(5, 2), readonly=True, states={'draft':[('readonly',False)]}),
        'margin': fields.function(_amount_all, digits=(5, 2), string='Brut margin (%)',
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),
        'margin_net': fields.function(_amount_all, digits=(5, 2), string='Net margin (%)',
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),
        'amount_margin': fields.function(_amount_all, digits_compute= dp.get_precision('Sale Price'), string='Brut margin',
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),
        'amount_margin_net': fields.function(_amount_all, digits_compute= dp.get_precision('Sale Price'), string='Net margin',
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),
        'amount_cost': fields.function(_amount_all, digits_compute= dp.get_precision('Sale Price'), string='Brut cost',
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),
        'amount_cost_net': fields.function(_amount_all, digits_compute= dp.get_precision('Sale Price'), string='Net cost',
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),
        'amount_untaxed_wo_rebate': fields.function(_amount_all, digits_compute= dp.get_precision('Sale Price'), string='Without rebate',
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),
        'amount_rebate': fields.function(_amount_all, digits_compute= dp.get_precision('Sale Price'), string='Rebate',
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),
        'amount_untaxed': fields.function(_amount_all, digits_compute= dp.get_precision('Sale Price'), string='Untaxed Amount',
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help="The amount without tax."),
        'amount_tax': fields.function(_amount_all, digits_compute= dp.get_precision('Sale Price'), string='Taxes',
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help="The tax amount."),
        'amount_total': fields.function(_amount_all, digits_compute= dp.get_precision('Sale Price'), string='Total',
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help="The total amount."),
                
        'partner_commission_id': fields.many2one('res.partner', "Partner commission", readonly=True, states={'draft': [('readonly', False)]}),
        'partner_percent_commission': fields.float('Partner commission (%)', readonly=True, states={'draft': [('readonly', False)]}),
        'partner_lines_commission': fields.function(_amount_all, string='Partner lines commission',digits_compute= dp.get_precision('Sale Price'),
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),
        'partner_amount_commission': fields.function(_amount_all, string='Partner amount commission',digits_compute= dp.get_precision('Sale Price'),
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),
        'partner_total_commission': fields.function(_amount_all, string='Partner total commission',digits_compute= dp.get_precision('Sale Price'),
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),
        
        'employee_commission_id': fields.many2one('res.users', "Employee commission", readonly=True, states={'draft': [('readonly', False)]}),
        'employee_percent_commission': fields.float('Employee commission (%)', readonly=True, states={'draft': [('readonly', False)]}),
        'employee_lines_commission': fields.function(_amount_all, string='Employee lines commission',digits_compute= dp.get_precision('Sale Price'),
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),
        'employee_amount_commission': fields.function(_amount_all, string='Employee amount commission',digits_compute= dp.get_precision('Sale Price'),
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),
        'employee_total_commission': fields.function(_amount_all, string='Employee total commission',digits_compute= dp.get_precision('Sale Price'),
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),

        'user_id': fields.many2one('res.users', 'Salesman', readonly=True, states={'draft': [('readonly', False)]}, select=True),
        'seller_percent_commission': fields.float('Seller commission (%)', readonly=True, states={'draft': [('readonly', False)]}),
        'seller_lines_commission': fields.function(_amount_all, string='Seller lines commission',digits_compute= dp.get_precision('Sale Price'),
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""), 
        'seller_amount_commission': fields.function(_amount_all, string='Seller amount commission',digits_compute= dp.get_precision('Sale Price'),
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),
        'seller_total_commission': fields.function(_amount_all, string='Seller total commission',digits_compute= dp.get_precision('Sale Price'),
            store = {
                'sale.order': (lambda self, cr, uid, ids, c={}: ids, ['order_line','rebate_percent','partner_percent_commission','employee_percent_commission','seller_percent_commission'], 10),
                'sale.order.line': (_get_order, ['price_unit', 'tax_id', 'discount', 'product_uom_qty'], 10),
            },
            multi='sums', help=""),

        'commissions': fields.function(_amount_all, method=True, store=True, string='Commissions',multi='sums',digits_compute= dp.get_precision('Sale Price')),
        'invoice_commission_id': fields.many2one('account.invoice', "Commission Invoice", ondelete='set null', readonly=True, select=True),
    }
    _defaults = {
        'user_id': lambda obj, cr, uid, context: False,
        'employee_commission_id': lambda obj, cr, uid, context: uid,
    }
sale_order()

class sale_order_line(osv.osv):
    _name = 'sale.order.line'
    _inherit = 'sale.order.line'

    def price_change(self, cr, uid, id, discount,price_unit,cost_price):
        if not manual_discount and partner_id and product_id:
            partner_rebate = self.get_partner_rebate(cr,uid,id,partner_id,product_id)
            return {'value': {'discount': partner_rebate or 0}}
        return {'value': {}}

    def product_id_change(self, cr, uid, ids, pricelist, product, qty=0,
            uom=False, qty_uos=0, uos=False, name='', partner_id=False,
            lang=False, update_tax=True, date_order=False, packaging=False, fiscal_position=False, flag=False, context=None):
        result = super(sale_order_line, self).product_id_change(cr, uid, ids, pricelist, product, qty, uom, qty_uos, uos, name, partner_id,lang, update_tax, date_order, packaging, fiscal_position, flag, context)
        result['value']['cost_price'] = 0.0
        if product:
            product = self.pool.get('product.product').browse(cr,uid,product)
            result['value']['cost_price'] = product.standard_price
        return result
    
    def _margin(self, cr, uid, ids, field_name, arg, context):
        res = {}
        company = self.pool.get('res.users').browse(cr, uid, uid).company_id
        employee_commission_perc = self.pool.get('hr.employee.commission.perc')
        product_category = self.pool.get('product.category')
        cur_obj = self.pool.get('res.currency')
        
        for line in self.browse(cr, uid, ids):
            res[line.id] = {'margin': 0.0, 'margin_net_customer': 0.0, 
                            'margin_net': 0.0, 'margin_net_net': 0.0, 
                            'partner_rebate': 0.0, 
                            'partner_rebate_percent': 0.0, 'partner_rebate_total': 0.0,
                            'seller_commission': 0.0, 
                            'employee_commission': 0.0, 'partner_commission': 0.0 }
            amount_net = 0.0
            cur = line.order_id.pricelist_id.currency_id
            if not line.cost_price:
                if line.product_id:
                    cost_price = line.product_id.standard_price
                else:
                    cost_price = line.price_unit * company.coef_standard_marge
            else:
                cost_price = line.cost_price
                
            employee_commission_unit = 0.0
            employee_commission_unit_total = 0.0
            partner_commission_unit = 0.0
            partner_commission_unit_total = 0.0
            seller_commission_unit = 0.0
            seller_commission_unit_total = 0.0
            partner_rebate_footer = 0.0
            if line.product_id:
                if line.product_id.categ_id:
                    categories = [line.product_id.categ_id] + product_category.get_all_parents(cr, uid, line.product_id.categ_id.id)

                    # Commission Partenaire
                    partner_percent = 1
                    partner_commission_unit = 0.0
                    partner_commission_unit_total = 0.0
                    if line.order_id.partner_commission_id:
                        for partner_commission_perc in line.order_id.partner_commission_id.commission_category_ids:
                            for category in categories:
                                if partner_commission_perc.category_id.id == category.id:
                                    if partner_commission_perc.commission_percent and ((not partner_commission_perc.date_start and not partner_commission_perc.date_stop) or (partner_commission_perc.date_start <= line.order_id.date_order and partner_commission_perc.date_stop >= line.order_id.date_order)):
                                        partner_percent *= 1 - partner_commission_perc.commission_percent / 100

                        if line.order_id.partner_id.commission_type == "brut":
                            partner_commission_unit = cur_obj.round(cr, uid, cur, line.price_net * (1- partner_percent))
                            partner_commission_unit_total = cur_obj.round(cr, uid, cur, line.price_net * (1-partner_percent)*(1- line.order_id.partner_percent_commission or 0.0))
                        elif line.order_id.partner_id.commission_type == "brut_margin":
                            partner_commission_unit = cur_obj.round(cr, uid, cur, (line.price_net - cost_price) * (1- partner_percent))
                            partner_commission_unit_total = cur_obj.round(cr, uid, cur, (line.price_net - cost_price) * (1-partner_percent)*(1- line.order_id.partner_percent_commission or 0.0))
                        else:
                            #Formule de brut_margin par défaut
                            partner_commission_unit = cur_obj.round(cr, uid, cur, (line.price_net - cost_price) * (1- partner_percent))
                            partner_commission_unit_total = cur_obj.round(cr, uid, cur, (line.price_net - cost_price) * (1-partner_percent)*(1- line.order_id.partner_percent_commission or 0.0))
                        res[line.id]['partner_commission'] = partner_commission_unit*line.product_uom_qty
                    
                    # Commission Employee
                    employee_percent = 1
                    employee_commission_unit = 0.0
                    employee_commission_unit_total = 0.0
                    if line.order_id.employee_commission_id:
                        employee_id = self.pool.get('hr.employee').get_employee_by_user(cr, uid, line.order_id.employee_commission_id.id)
                        if employee_id:
                            for employee_commission_perc in employee_id.commission_category_ids:
                                for category in categories:
                                    if employee_commission_perc.category_id.id == category.id:
                                        if employee_commission_perc.commission_percent and ((not employee_commission_perc.date_start and not employee_commission_perc.date_stop) or (employee_commission_perc.date_start <= line.order_id.date_order and employee_commission_perc.date_stop >= line.order_id.date_order)):
                                            employee_percent *= 1 - employee_commission_perc.commission_percent / 100

                            if employee_id.commission_type == "brut":
                                employee_commission_unit = cur_obj.round(cr, uid, cur, line.price_net * (1- employee_percent))
                                employee_commission_unit_total = cur_obj.round(cr, uid, cur, line.price_net * (1-employee_percent)*(1- line.order_id.employee_percent_commission or 0.0))
                            elif employee_id.commission_type == "brut_margin":
                                employee_commission_unit = cur_obj.round(cr, uid, cur, (line.price_net - cost_price) * (1- employee_percent))
                                employee_commission_unit_total = cur_obj.round(cr, uid, cur, (line.price_net - cost_price) * (1-employee_percent)*(1- line.order_id.employee_percent_commission or 0.0))
                            else:
                                #Formule de brut_margin par défaut
                                employee_commission_unit = cur_obj.round(cr, uid, cur, (line.price_net - cost_price) * (1- employee_percent))
                                employee_commission_unit_total = cur_obj.round(cr, uid, cur, (line.price_net - cost_price) * (1-employee_percent)*(1- line.order_id.employee_percent_commission or 0.0))
                            res[line.id]['employee_commission'] = employee_commission_unit*line.product_uom_qty

                    # Commission Vendeur
                    seller_percent = 1
                    seller_commission_unit = 0.0
                    seller_commission_unit_total = 0.0
                    if line.order_id.user_id:
                        seller_id = self.pool.get('hr.employee').get_employee_by_user(cr, uid, line.order_id.user_id.id)
                        if seller_id:
                            for seller_commission_perc in seller_id.commission_category_ids:
                                for category in categories:
                                    if seller_commission_perc.category_id.id == category.id:
                                        if seller_commission_perc.commission_percent and ((not seller_commission_perc.date_start and not seller_commission_perc.date_stop) or (seller_commission_perc.date_start <= line.order_id.date_order and seller_commission_perc.date_stop >= line.order_id.date_order)):
                                            seller_percent *= 1 - seller_commission_perc.commission_percent / 100
                            if seller_id.commission_type == "brut":
                                seller_commission_unit = cur_obj.round(cr, uid, cur, line.price_net * (1- seller_percent))
                                seller_commission_unit_total = cur_obj.round(cr, uid, cur, line.price_net * (1-seller_percent)*(1- line.order_id.seller_percent_commission or 0.0))
                            elif seller_id.commission_type == "brut_margin":
                                seller_commission_unit = cur_obj.round(cr, uid, cur, (line.price_net - cost_price) * (1- seller_percent))
                                seller_commission_unit_total = cur_obj.round(cr, uid, cur, (line.price_net - cost_price) * (1-seller_percent)*(1- line.order_id.seller_percent_commission or 0.0))
                            else:
                                #Formule de brut_margin par défaut
                                seller_commission_unit = cur_obj.round(cr, uid, cur, (line.price_net - cost_price) * (1- seller_percent))
                                seller_commission_unit_total = cur_obj.round(cr, uid, cur, (line.price_net - cost_price) * (1-seller_percent)*(1- line.order_id.seller_percent_commission or 0.0))
                            res[line.id]['seller_commission'] = seller_commission_unit*line.product_uom_qty

                    partner_rebate = 1
                    partner_rebate_percent_footer = 0.0
                    partner_rebate_percent_total = 0.0
                    partner_rebate_footer = 0.0
                    if line.order_id.partner_id:
                        if not line.manual_discount:
                            for category in categories:
                                for category_rebate in category.partner_rebate_ids:
                                    if category_rebate.partner_id.id == line.order_id.partner_id.id or not category_rebate.partner_id:
                                        if category_rebate.rebate_percent and ((not category_rebate.date_start and not category_rebate.date_stop) or (category_rebate.date_start <= line.order_id.date_order and category_rebate.date_stop >= line.order_id.date_order)):
                                            partner_rebate *= 1 - category_rebate.rebate_percent / 100
                        else:
                            partner_rebate *= 1 - line.discount / 100
                        partner_rebate_percent_footer = line.order_id.partner_id.rebate_percent and (1 - line.order_id.partner_id.rebate_percent / 100) or 1.0
                        partner_rebate_percent_total = partner_rebate_percent_footer * partner_rebate
    
                        res[line.id]['partner_rebate'] = line.price_unit * (1 - partner_rebate )
                        res[line.id]['partner_rebate_percent'] = (1 - partner_rebate_percent_total) * 100
                        res[line.id]['partner_rebate_total'] = line.price_unit * (1 - partner_rebate_percent_total)
                        partner_rebate_footer = line.price_net * (1 - partner_rebate_percent_footer)

            if line.price_net:
                res[line.id]['margin'] = ((line.price_net - cost_price)/line.price_net) * 100
                res[line.id]['margin_net_customer'] = res[line.id]['margin'] - (line.order_id.rebate_percent or 0.0)
                res[line.id]['margin_net'] = ((line.price_net - (cost_price + (seller_commission_unit or 0.00) + (employee_commission_unit or 0.00) + (partner_commission_unit or 0.00)))/line.price_net) * 100
                res[line.id]['margin_net_net'] = ((line.price_net - (cost_price + (partner_rebate_footer or 0.00) + (seller_commission_unit_total or 0.00) + (employee_commission_unit_total or 0.00) + (partner_commission_unit_total or 0.00)))/line.price_net) * 100
            else:
                res[line.id]['margin'] = -100.0
                res[line.id]['margin_net_customer'] = -100.0
                res[line.id]['margin_net'] = -100.0
                res[line.id]['margin_net_net'] = -100.0
                
        return res

    
    def get_partner_rebate(self,cr,uid,ids,partner_id,product_id):
        partner_rebate = 1
        line = self.browse(cr,uid,ids)
        if partner_id and product_id:
            partner_obj = self.pool.get('res.partner')
            product_obj = self.pool.get('product.product')
            categ_obj = self.pool.get('product.category')
            partner = partner_obj.browse(cr,uid,partner_id)
            product = product_obj.browse(cr,uid,product_id)
            categories = [product.categ_id] + categ_obj.get_all_parents(cr, uid, product.categ_id.id)
            for category in categories:
                for category_rebate in category.partner_rebate_ids:
                    if category_rebate.partner_id.id == partner.id or not category_rebate.partner_id:
                        if category_rebate.rebate_percent and ((not category_rebate.date_start and not category_rebate.date_stop) or (category_rebate.date_start <= line.order_id.date_order and category_rebate.date_stop >= line.order_id.date_order)):
                            partner_rebate *= 1 - category_rebate.rebate_percent / 100
        return (1 - partner_rebate ) * 100
        
    def _set_discount(self, cr, uid, ids, name, value, arg, context):
        if isinstance(value,bool):
            return False
        if isinstance(ids, (int, long)):
            ids = [ids]
        for id in ids:
            if self.read(cr,uid,id,["manual_discount"])['manual_discount']:
                cr.execute('update sale_order_line set discount = %s where id = %s' % (value,id))
        return True

    def _get_discount(self, cr, uid, ids, field_name, arg, context={}):
        order_obj = self.pool.get('sale.order')
        res = {}
        for id in ids:
            line = self.read(cr,uid,id,["manual_discount","product_id","order_id","state"])
            order = order_obj.read(cr,uid,line['order_id'][0],["partner_id"])
            if not line['manual_discount']:
                res[id] = self.get_partner_rebate(cr,uid,id,order['partner_id'][0],line['product_id'] and line['product_id'][0] or False)
        return res
    
    def manual_discount_change(self, cr, uid, id, manual_discount,partner_rebate,partner_id,product_id):
        if not manual_discount and partner_id and product_id:
            partner_rebate = self.get_partner_rebate(cr,uid,id,partner_id,product_id)
            return {'value': {'discount': partner_rebate or 0}}
        return {'value': {}}
    
    def _amount_line_net(self, cr, uid, ids, field_name, arg, context):
        res = {}
        for line in self.browse(cr, uid, ids):
            res[line.id] = line.price_unit * (1 - (line.discount or 0.0) / 100.0)
        return res
    
    _columns = {
         'margin': fields.function(_margin, store=True, multi="commission", method=True, string='Margin(%)', digits_compute= dp.get_precision('Sale Price')), 
         'margin_net': fields.function(_margin, store=True, multi="commission", method=True, string='Net margin(%)', digits_compute= dp.get_precision('Sale Price')),
         'margin_net_customer': fields.function(_margin, store=True, multi="commission", method=True, string='Net margin customer(%)', digits_compute= dp.get_precision('Sale Price')),
         'margin_net_net': fields.function(_margin, store=True, multi="commission", method=True, string='Net-Net margin(%)', digits_compute= dp.get_precision('Sale Price')),
         'cost_price': fields.float('Cost price', readonly=True, states={'draft':[('readonly',False)]}),
         'seller_commission': fields.function(_margin, store=True, multi="commission", method=True, string='Seller Commission', type='float'),
         'employee_commission': fields.function(_margin, store=True, multi="commission", method=True, string='Employee Commission', type='float'),
         'partner_commission': fields.function(_margin, store=True, multi="commission", method=True, string='Partner Commission', type='float'),
         'partner_rebate': fields.function(_margin, store=True, multi="commission", method=True, string='Partner Rebate', digits_compute= dp.get_precision('Sale Price')),
         'partner_rebate_percent': fields.function(_margin, store=False, multi="commission", method=True, string='Partner Rebate (%)', digits_compute= dp.get_precision('Sale Price')),
         'partner_rebate_total': fields.function(_margin, store=False, multi="commission", method=True, string='Partner Rebate Total',digits_compute= dp.get_precision('Sale Price')),
         'manual_discount' : fields.boolean('Manual discount', readonly=True, states={'draft':[('readonly',False)],'waiting_date':[('readonly',False)]}),
         'manual_price' : fields.boolean('Manual price', readonly=True, states={'draft':[('readonly',False)],'waiting_date':[('readonly',False)]}),
         'discount': fields.function(_get_discount, fnct_inv=_set_discount,method=True, store=True, type='float',digits_compute= dp.get_precision('Sale Price'), string='Discount (%)', select=1),
         'price_net': fields.function(_amount_line_net, method=True, string='Net Price', digits_compute= dp.get_precision('Sale Price')),
    }
    _defaults = {
        'manual_discount': lambda *a: True,
        'manual_price': lambda *a: True,
        'product_uom_qty': lambda *a: 1,
        'product_uos_qty': lambda *a: 1,
        'delay': lambda *a: 2,
    }

sale_order_line()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4: