# -*- encoding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2010-2012 ASPerience SARL (<http://www.asperience.fr>).
#    All Rights Reserved
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################


import netsvc
import logging
import pooler
import datetime, time
from osv import fields, osv, orm
from tools.translate import _
import decimal_precision as dp
import logging
from pprint import pprint
from tools import DEFAULT_SERVER_DATETIME_FORMAT

class product_category(osv.osv):
    _name = "product.category"
    _inherit ='product.category'
    
    def get_all_parents(self, cr, uid, ids, context={}):
        
        if isinstance(ids,list):
            id = ids[0]
        else:
            id = ids
        res = []
        
        def get_parent(res, category):
            if category.parent_id:
                res.append(category.parent_id)
                return get_parent(res, category.parent_id)
            else:
                return res             
        
        category = self.browse(cr, uid, id, context)
        
        return get_parent(res, category)
    
    _columns = {
        'partner_rebate_ids': fields.one2many('res.partner.rebate.perc', 'category_id', 'Categories Rebates'),
    }

product_category()
# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4: