# -*- encoding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2010-2012 ASPerience SARL (<http://www.asperience.fr>).
#    All Rights Reserved
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import fields,osv

class res_partner(osv.osv):
    _name = "res.partner"
    _inherit = "res.partner"
    
    _columns = {
        'rebate_percent': fields.float('Rebate (%)', digits=(5, 2)),
        'rebate_category_ids': fields.one2many('res.partner.rebate.perc', 'partner_id', 'Categories Rebates'),
        'commission_global_percent': fields.float('Commission (%)', digits=(5, 2)),
        'commission_type': fields.selection([('brut', 'Brut'), ('brut_margin', 'Brut Margin')], 'Commission Type', select=True),
        'commission_category_ids': fields.one2many('res.partner.commission.perc', 'partner_id', 'Categories Commissions'),
        'customer_type': fields.selection([('distributor', 'Distributor'), ('executive_contract', 'Executive contract'), ('direct', 'Direct')], 'Customer Type'),
        'department_id': fields.many2one('hr.department', 'Department'),
    }
    def get_parent_root(self, cr, uid, ids, context={}):
        if isinstance(ids,list):
            id = ids[0]
        else:
            id = ids
        res = False
        def get_parent(ptr):
            if not ptr:
                return False                    
            return get_parent(ptr.parent_id) or ptr.id
        
        ptr = self.browse(cr,uid,id,context)
        return get_parent(ptr)
            
res_partner()

class res_partner_commission_perc(osv.osv):
    _name = "res.partner.commission.perc"
    _description = "Partner Commission Percent"
    
    _columns = {
        'partner_id' : fields.many2one("res.partner", "Partner", required=True, ondelete='cascade'),
        'category_id' : fields.many2one("product.category", "Category", required=True, ondelete='cascade'),
        'commission_percent': fields.float('Commission (%)', digits=(5, 2)),
        'date_start': fields.date('Date Start'),
        'date_stop': fields.date('Date Stop'),
    }
    
res_partner_commission_perc()

class res_partner_rebate_perc(osv.osv):
    _name = "res.partner.rebate.perc"
    _description = "Partner Rebate Percent"
    
    _columns = {
        'category_id' : fields.many2one("product.category", "Category", required=True, ondelete='cascade'),
        'partner_id' : fields.many2one("res.partner", "Partner", ondelete='cascade'),
        'rebate_percent': fields.float('Rebate (%)', digits=(5, 2)),
        'date_start': fields.date('Date Start'),
        'date_stop': fields.date('Date Stop'),
    }

res_partner_rebate_perc()
# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4: