# -*- encoding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2010-2012 ASPerience SARL (<http://www.asperience.fr>).
#    All Rights Reserved
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################


import netsvc
import logging
import pooler
import datetime, time
from osv import fields, osv, orm
from tools.translate import _
import decimal_precision as dp
import logging
from pprint import pprint
from tools import DEFAULT_SERVER_DATETIME_FORMAT

class hr_employee(osv.osv):
    _name = "hr.employee"
    _inherit = "hr.employee"
    
    def get_employee_by_user(self, cr, uid, id, context={}):
        employee_ids = self.search(cr, uid, [('user_id','=', id)])
        if employee_ids:
            return self.browse(cr, uid, employee_ids[0])
        return False
        
    _columns = {
        'commission_ids': fields.one2many('hr.employee.commission', 'employee_id','Commission'),
        'commission_category_ids': fields.one2many('hr.employee.commission.perc', 'employee_id','Categories Commissions'),
        'commission_global_percent': fields.float(string='Commission Global (%)', digits=(5, 2)),
        'commission_type': fields.selection([('brut', 'Brut'), ('brut_margin', 'Brut Margin')], 'Commission Type', select=True),
    }
    
    
hr_employee()

class hr_employee_commission(osv.osv):
    _name = "hr.employee.commission"
    _description = "Employee Commission"
    
    _columns = {
        'date' : fields.date('Date'),
        'state' : fields.selection([('draft','Draft'),('done','Done')], 'State', required=True),
        'amount': fields.float('Amount', digits=(16, 2)),
        'employee_id' : fields.many2one("hr.employee", "Employee", required=True, ondelete='cascade'),
        'sale_order_id' : fields.many2one("sale.order", "Sale Order", ondelete='cascade'),
    }
    _order="employee_id, date desc, state"
hr_employee_commission()

class hr_employee_commission_perc(osv.osv):
    _name = "hr.employee.commission.perc"
    _description = "Employee Commission Percent"
    
    _columns = {
        'employee_id' : fields.many2one("hr.employee", "Employee", required=True, ondelete='cascade'),
        'category_id' : fields.many2one("product.category", "Category", required=True, ondelete='cascade'),
        'commission_percent': fields.float('Commission (%)', digits=(5, 2)),
        'date_start': fields.date('Date Start'),
        'date_stop': fields.date('Date Stop'),
    }

hr_employee_commission_perc()

class ir_action_window(osv.osv):
    _inherit = 'ir.actions.act_window'

    def read(self, cr, uid, ids, fields=None, context=None,
            load='_classic_read'):
        select = ids
        if isinstance(ids, (int, long)):
            select = [ids]
        res = super(ir_action_window, self).read(cr, uid, select, fields=fields,
                context=context, load=load)
        for r in res:
            mystring_dep = 'get_departments_by_user()'
            mystring_all_dep = 'get_all_departments_by_user()'
            mystring_emp = 'get_employee_by_user()'
            if mystring_dep in (r.get('domain', '[]') or ''):
                department_parent_ids = self.pool.get('hr.department').search(cr,uid,[('member_ids', '=', uid)])
                if department_parent_ids:
                    department_ids = self.pool.get('hr.department').search(cr,uid,[('parent_id', 'in', department_parent_ids)])
                    r['domain'] = r['domain'].replace(mystring_dep, str(department_ids))
            elif mystring_all_dep in (r.get('domain', '[]') or ''):
                department_parent_ids = self.pool.get('hr.department').search(cr,uid,[('member_ids', '=', uid)])
                department_ids = list(department_parent_ids)
                department_ids.extend([])
                if department_parent_ids:
                    department_ids.extend(self.pool.get('hr.department').search(cr,uid,[('parent_id', 'in', department_parent_ids)]))
                r['domain'] = r['domain'].replace(mystring_all_dep, str(department_ids))
            elif mystring_emp in (r.get('domain', '[]') or ''):
                employee = self.pool.get('hr.employee').get_employee_by_user(cr, uid, uid)
                if employee:
                    r['domain'] = r['domain'].replace(mystring_emp, str(employee.id))
        if isinstance(ids, (int, long)):
            if res:
                return res[0]
            else:
                return False
        return res

ir_action_window()
# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4: