# -*- encoding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2010-2012 ASPerience SARL (<http://www.asperience.fr>).
#    All Rights Reserved
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import fields, osv

class res_company(osv.osv):
    _inherit = "res.company"
    _columns = {
        'property_product_uom_hour': fields.property(
            'product.uom',
            type='many2one', 
            relation='product.uom', 
            string="Product UOM Hour", 
            method=True,
            view_load=True,
            help="In order to convert hours on sale.order to hours on projects"),
        'margin_percent': fields.float('Margin percent (%)', digits=(5, 2), readonly=True, states={'draft':[('readonly',False)]}),
        'commission_percent': fields.float('Commission percent (%)', digits=(5, 2), readonly=True, states={'draft':[('readonly',False)]}),
        'commercial_commission_percent': fields.float('Commercial commission percent (%)', digits=(5, 2), readonly=True, states={'draft':[('readonly',False)]}),
        'internal_percent': fields.float('Internal percent', digits=(5, 2), readonly=True, states={'draft':[('readonly',False)]}),
        'company_min_margin_sale_validation': fields.float('Company minimum margin sale validation', digits=(5, 2), readonly=True, states={'draft':[('readonly',False)]}),
        'commission_on': fields.selection([('on_sale','on sale'),('on_invoice','on invoice'),('on_paid','on paid')],'Commission'),
        'account_commission_id': fields.many2one('account.account', 'Account commission'),
        'sale_on_client_purchase_order': fields.boolean('Sales are CPO based'),
        'sale_on_client_lot' : fields.boolean('Client Lot based (*)'),
        'sale_on_client_list' : fields.boolean('Sales are partner datas based'),
        'sale_on_packaging' : fields.boolean('Sales are based on packagings'),
        'coef_standard_marge': fields.float('Margin coefficient (%)', digits=(5, 2)),
    }
    _defaults = {
        'coef_standard_marge': lambda *a: 0.8,
    }
res_company()
# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4: